const _ = require("underscore");

module.exports.serialize = function (obj, stop = false) {
    const data = _.map(JSON.stringify(obj), i => i.charCodeAt(0));
    if (stop) {
        data.push(0);
    }

    return data;
}

module.exports.deserialize = function (data) {
    const end = data && data.indexOf(0);
    try {
        return JSON.parse(_.map(end >= 0 ? data.slice(0, end) : data, byte => String.fromCharCode(byte)).join(""));
    } catch (e) {
        return null;
    }
}

module.exports.chunk = function (data, size) {
    return Array(Math.ceil(data.length / size)).fill().map((_, index) => index * size).map(begin => data.slice(begin, begin + size));
}